"""
URL configuration for meraki_Interface_forward project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from . import task
# 直接从子模块导入，避免 views.py 和 views/ 目录的命名冲突
from .views import device_views, status_views, cache_views, zabbix_views, juniper_views

urlpatterns = [
    # path('admin/', admin.site.urls),
    path('discovery/host_prototype', device_views.discovery_host_prototype),
    path('discovery/host_prototype/filter', device_views.discovery_host_prototype_filter),
    path('zabbix/sync_hosts', zabbix_views.sync_meraki_to_zabbix),
    path('zabbix/sync_juniper_hosts', juniper_views.sync_juniper_to_zabbix),
    path('all_host', device_views.get_device_by_serial_or_product_type),
    path('device/status', status_views.get_device_status),
    path('device/status/overview', status_views.get_device_status_overview),
    path('device/ap/channel_utilization', device_views.get_device_ap_channelUtilization),
    path('device/switch/ports/status', device_views.get_device_switch_ports_status),
    path('device/uplinks', device_views.get_device_uplink),
    path('device/alert', status_views.get_device_alert),
    path('task', task.synchronization_data),
    path('cache', cache_views.cache_get_device),
    path('cache/clear', cache_views.clear_cache),
]
