# from django.http import JsonResponse
# import meraki
# import os
# import traceback
# from django.core.cache import cache
# import time
# from django.dispatch import Signal, receiver
# from concurrent.futures import ThreadPoolExecutor, as_completed
# from xml.sax import parse
# import random
# import uuid
# import json
#
# # sike 设备类型 'appliance', 'camera', 'campusGateway', 'cellularGateway', 'secureConnect', 'sensor', 'switch', 'systemsManager', 'wireless' or 'wirelessController'
# from meraki_Interface_forward.resultAnalysis import resultAnalysis
# from meraki_Interface_forward.settings import response
#
# API_KEY = os.getenv("MERAKI_API_KEY")
# ORGANIZATION_ID = os.getenv("ORGANIZATION_ID")
# MERAKI_API_BASE = os.getenv("MERAKI_API_BASE")
# dashboard = meraki.DashboardAPI(
#     api_key=API_KEY,
#     base_url=MERAKI_API_BASE,
#     output_log=True,
#     suppress_logging=True,
#     wait_on_rate_limit=True,
#     nginx_429_retry_wait_time=3,
#     maximum_retries=3  # 最大重试次数
# )
# # 定义信号
# data_fetched = Signal()
#
# # 创建线程池
# executor = ThreadPoolExecutor(max_workers=5)  # 同时处理5个任务
#
#
# # @receiver(data_fetched)
# def handle_data_fetched(sender, **kwargs):
#     data = kwargs.get("data")
#     print("接收带事件 开始执行 获取设备的接口信息 ： " + str(data))
#
#     # 异步提交给线程池处理
#     executor.submit(process_all_tasks, data)
#
#
# def process_all_tasks(data):
#     futures = []
#     combined_result = {}
#
#     # 三个任务全部异步提交
#     futures.append(executor.submit(get_organization_devices))
#     futures.append(executor.submit(get_device_ports, data))
#     futures.append(executor.submit(get_device_availabilities))
#
#     print("执行到这")
#     # 按完成顺序汇总（阻塞等待全部完成）
#     for future in as_completed(futures):
#         result = future.result()
#         combined_result.update(result)
#     # 你可以在此存储结果，例如存数据库或缓存
#     # print("三个任务已全部完成，最终组装结果：")
#
#
# def discovery_host_prototype(request):
#     try:
#         print("获取到的组织ID: " + ORGANIZATION_ID)
#         devices = get_organization_devices()
#
#         print("获取到的设备数量 " + str(len(devices)))
#         if len(devices):
#
#             # 缓存数据
#             cache.set("meraki_devices", devices, timeout=300)
#             serial_array = []
#             for device in devices:
#                 print(str(device['serial']))
#                 serial_array.append(device['serial'])
#             # 发布事件
#             data_fetched.send(sender=discovery_host_prototype, data=serial_array)
#             return JsonResponse(devices, safe=False,
#                                 json_dumps_params={'indent': 2, 'ensure_ascii': False})
#
#     except Exception as e:
#         print("获取到的设备信息； 发生异常：", e)
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_organization_devices():
#     devices = dashboard.organizations.getOrganizationDevices(
#         ORGANIZATION_ID,
#         perPage=1000,
#         total_pages='all'
#     )
#     return devices
#
#
# def get_organization_networks():
#     try:
#         networks = dashboard.organizations.getOrganizationNetworks(
#             ORGANIZATION_ID,
#             perPage=1000,
#             total_pages='all'
#         )
#         print("networks 属性 ", type(networks))
#         if len(networks):
#             cache.set("meraki_networks", networks, timeout=3600)
#             return networks
#     except Exception as e:
#         msg = str(e)
#         if "Expecting value: line 1 column 1" in msg:
#             return []
#         traceback.print_exc()
#         print('缓存组织下的networks失败' + msg)
#         return []
#
#
# def cache_get_device(request):
#     res = cache.get("meraki_devices")
#     data_is_valid = cache.touch("meraki_devices", timeout=None)
#
#     return JsonResponse(
#         {"device": res[0], "dataIsValid": data_is_valid} if data_is_valid else {"error": "当前缓存数据已超时 ！！"},
#         safe=False,
#         json_dumps_params={'indent': 2, 'ensure_ascii': False})
#
#
# """ async 批量获取设备的端口信息 """
#
#
# def get_device_ports(serial_array):
#     res_serial_array = []
#     res_serial_dict = {}
#     if not serial_array:
#         return None
#     else:
#         for serial in serial_array[:3]:
#             response = dashboard.switch.getDeviceSwitchPorts(serial)
#             if response:
#                 res_serial_dict.update({serial: response})
#             # time.sleep(0.05)
#             # print(str(response))
#         return res_serial_dict
#
#
# def get_device_availabilities():
#     try:
#         device = {}
#         res = dashboard.organizations.getOrganizationDevicesAvailabilities(ORGANIZATION_ID)
#         if not res:
#             return {}
#         else:
#             for dev in res:
#                 device.update({dev['serial']: dev['status']})
#             return device
#
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_device_by_serial_or_product_type(request):
#     if request.method != 'GET':
#         return JsonResponse({"message": "Method Not Allowed"}, status=405)
#
#     try:
#         serial = request.GET.get('serial')
#         product_type = request.GET.get('productType')
#
#         if not serial or not product_type:
#             return JsonResponse({"message": "缺少查询参数 serial 或 productType"}, status=400)
#
#         print(f"请求参数：serial={serial}, productType={product_type}")
#         network_map = {}
#         # 1. 获取 Network 映射
#         networks = get_organization_networks()
#         if networks:
#             print("获取到的网络数量:", len(networks))
#             network_map = {net["id"]: net["name"] for net in networks}
#
#             # 2. 获取缓存中 Meraki 设备
#         meraki_devices = cache.get("meraki_devices")
#
#         # 3. 若缓存有数据，从缓存中查
#         if meraki_devices:
#             for device in meraki_devices:
#
#                 # 安全获取 networkId
#                 net_id = device['networkId']
#                 if network_map:
#                     device["networkName"] = network_map.get(net_id)
#
#                 # 匹配设备
#                 if (
#                         device.get("serial") == serial
#                         and device.get("productType") == product_type
#                 ):
#                     return JsonResponse(
#                         {"device": device},
#                         safe=False,
#                         json_dumps_params={"indent": 2, "ensure_ascii": False},
#                     )
#
#         # 4. 缓存未命中 → 调 Meraki API 查询单设备
#         print("缓存未命中，调用 Meraki API 查询设备:", serial)
#         try:
#             device = dashboard.devices.getDevice(serial)
#         except Exception as api_err:
#             print("Meraki API 查询失败：", api_err)
#             return JsonResponse({"message": "Meraki API 查询失败或设备不存在"}, status=404)
#
#         if device:
#             net_id = device.get("networkId")
#             device["networkName"] = network_map.get(net_id)
#
#             return JsonResponse(
#                 {"device": device},
#                 safe=False,
#                 json_dumps_params={"indent": 2, "ensure_ascii": False},
#             )
#
#         # 5. 找不到设备
#         return JsonResponse(
#             {"error": "未找到匹配的设备"},
#             status=404
#         )
#
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_device_status_overview(request):
#     try:
#         res = dashboard.organizations.getOrganizationDevicesStatusesOverview(ORGANIZATION_ID)
#         if res:
#             return JsonResponse(res, safe=False,
#                                 json_dumps_params={'indent': 2, 'ensure_ascii': False})
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_device_status(request):
#     serial = request.GET.get('serial')
#     product_type = request.GET.get('productType')
#
#     try:
#         res = dashboard.organizations.getOrganizationDevicesAvailabilities(ORGANIZATION_ID, perPage=1000,
#                                                                            total_pages='all')
#
#         cache.set("devices_status", res, timeout=30)
#         if res:
#             for device in res:
#                 if device['serial'] == serial and device['productType'] == product_type:
#                     return JsonResponse({"status": device['status']}, safe=False,
#                                         json_dumps_params={'indent': 2, 'ensure_ascii': False})
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_device_uplink(request):
#     serial = request.GET.get('serial')
#     product_type = request.GET.get('productType')
#     try:
#
#         res = dashboard.organizations.getOrganizationDevicesUplinksAddressesByDevice(
#             ORGANIZATION_ID,
#             perPage=1000,
#             total_pages='all',
#         )
#
#         if res:
#             for device in res:
#                 if device['serial'] == serial and device['productType'] == product_type:
#                     return JsonResponse(device, safe=False,
#                                         json_dumps_params={'indent': 2, 'ensure_ascii': False})
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)
#
#
# def get_device_ap_channelUtilization(request):
#     try:
#         serial = request.GET.get('serial')
#         if not serial:
#             return JsonResponse({"message": "缺少查询参数 serial"}, status=400)
#         res = dashboard.wireless.getOrganizationWirelessDevicesChannelUtilizationByDevice(
#             ORGANIZATION_ID,
#             perPage=1000,
#             total_pages='all',
#             timespan=3600
#         )
#         if isinstance(res, list) and res:
#             for device in res:
#                 if device.get('serial') == serial:
#                     return JsonResponse(device, safe=False, json_dumps_params={'indent': 2, 'ensure_ascii': False})
#         else:
#             return JsonResponse({"error": "无可用的信道利用率数据"}, status=404)
#
#     except Exception as e:
#         msg = str(e)
#         if "Expecting value: line 1 column 1" in msg:
#             return JsonResponse({"error": "Meraki 返回空响应或非 JSON，可能为 204/HTML 页面。请检查 base_url、组织访问权限，或稍后重试。"}, status=502)
#         traceback.print_exc()
#         return JsonResponse({"error": msg}, status=500)
#
#
# def get_device_switch_ports_status(request):
#     try:
#         serial = request.GET.get('serial')
#         if not serial:
#             return JsonResponse({"message": "缺少查询参数 serial"}, status=400)
#         res = dashboard.switch.getDeviceSwitchPortsStatuses(
#             serial,
#             timespan=3600
#         )
#         if res:
#             return JsonResponse(res, safe=False, json_dumps_params={'indent': 2, 'ensure_ascii': False})
#
#     except Exception as e:
#         traceback.print_exc()
#         return JsonResponse({"error": str(e)}, status=500)