import os
import sys
from datetime import date, timedelta
PROJECT_ROOT = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
if PROJECT_ROOT not in sys.path:
    sys.path.insert(0, PROJECT_ROOT)
from meraki_Interface_forward.settings import CustomTimedRotatingFileHandler

ROOT = os.path.dirname(os.path.abspath(__file__))
LOG_DIR = os.path.join(ROOT, "logs_verify")
os.makedirs(LOG_DIR, exist_ok=True)
BASE_FILE = os.path.join(LOG_DIR, "meraki.log")

with open(BASE_FILE, "w", encoding="utf-8") as f:
    f.write("")

for i in range(10):
    d = date.today() - timedelta(days=i + 1)
    fn = os.path.join(LOG_DIR, f"meraki.{d.strftime('%Y%m%d')}.log")
    with open(fn, "w", encoding="utf-8") as f:
        f.write(f"{d.isoformat()}\n")

handler = CustomTimedRotatingFileHandler(BASE_FILE, when="midnight", backupCount=6)
to_delete = handler.getFilesToDelete()
for p in to_delete:
    try:
        os.remove(p)
    except OSError:
        pass

remaining = []
for f in os.listdir(LOG_DIR):
    if f.startswith("meraki.") and f.endswith(".log") and f != "meraki.log":
        remaining.append(f)

print(f"remaining_history={len(remaining)}")
print("\n".join(sorted(remaining)))

if len(remaining) == 6:
    print("OK")
    exit(0)
else:
    print("FAILED")
    exit(1)
