# 入参 response
# 解析返回结构 list 或者 object

import logging
import json

logger = logging.getLogger(__name__)

def resultAnalysis(response):
    result = {
        "success": False,
        "code": None,
        "message": "",
        "data": None
    }

    try:
        # --- Step 1: 判断响应类型 ---
        if hasattr(response, "status_code"):  # requests.Response 类型
            result["code"] = response.status_code

            # 优先尝试解析 JSON 内容
            try:
                body = response.json()
            except Exception:
                body = response.text

            # --- Step 2: 根据状态码判断 ---
            if 200 <= response.status_code < 300:
                result["success"] = True
                result["message"] = "请求成功"
                result["data"] = body
            elif response.status_code == 401:
                result["message"] = "认证失败或API Key无效"
            elif response.status_code == 403:
                result["message"] = "访问被拒绝，权限不足"
            elif response.status_code == 404:
                result["message"] = "请求的资源不存在"
            elif response.status_code >= 500:
                result["message"] = "服务器内部错误"
            else:
                result["message"] = f"请求失败，HTTP状态码 {response.status_code}"

        elif isinstance(response, dict):  # 已解析的 JSON 对象
            code = response.get("code") or response.get("status") or 200
            result["code"] = code
            result["data"] = response

            # --- Step 3: 判断业务状态 ---
            if code in [200, 0]:
                result["success"] = True
                result["message"] = response.get("message", "请求成功")
            else:
                result["message"] = response.get("message", "业务处理失败")

        elif isinstance(response, str):
            # 若返回为字符串（可能是错误消息）
            result["message"] = response

        else:
            result["message"] = "无法识别的响应类型"

    except Exception as e:
        logger.error(f"解析响应失败: {e}")
        result["message"] = f"响应解析异常: {e}"

    logger.info(f"解析结果 => success={result['success']}, code={result['code']}, message={result['message']}")
    return result


