"""
Django settings for meraki_Interface_forward project.

Generated by 'django-admin startproject' using Django 5.2.8.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

from pathlib import Path
import os
import json
import logging
from logging.handlers import TimedRotatingFileHandler
from dotenv import load_dotenv
import meraki

from .redis_utils import redis_ping, set, get , CacheKey
# 加载项目根目录下的 .env 文件
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
load_dotenv(os.path.join(BASE_DIR, '.env'))


REDIS_URL = os.getenv("REDIS_URL")
REDIS_HOST = os.getenv("REDIS_HOST")
REDIS_PORT = os.getenv("REDIS_PORT")
REDIS_DB = os.getenv("REDIS_DB")
REDIS_USERNAME = os.getenv("REDIS_USERNAME")
REDIS_PASSWORD = os.getenv("REDIS_PASSWORD")
try:
    import django_redis  # type: ignore
except Exception:
    raise RuntimeError("启动失败：未安装 django-redis，已将 Redis 设为强制依赖")

def _build_redis_location():
    host = REDIS_HOST or "127.0.0.1"
    port = int(REDIS_PORT or "6379")
    db = int(REDIS_DB or "8")
    if REDIS_HOST or REDIS_PORT or REDIS_DB or REDIS_USERNAME or REDIS_PASSWORD or not REDIS_URL:
        auth = ""
        if REDIS_USERNAME and REDIS_PASSWORD:
            auth = f"{REDIS_USERNAME}:{REDIS_PASSWORD}@"
        elif REDIS_PASSWORD and not REDIS_USERNAME:
            auth = f":{REDIS_PASSWORD}@"
        elif REDIS_USERNAME and not REDIS_PASSWORD:
            auth = f"{REDIS_USERNAME}:@"
        return f"redis://{auth}{host}:{port}/{db}"
    return REDIS_URL

CACHES = {
    'default': {
        'BACKEND': 'django_redis.cache.RedisCache',
        'LOCATION': _build_redis_location(),
        'OPTIONS': {
            'CLIENT_CLASS': 'django_redis.client.DefaultClient',
            'PASSWORD': REDIS_PASSWORD,
            'USERNAME': REDIS_USERNAME,
        }
    }
}

redis_status = redis_ping()
if not redis_status.get("connected"):
    raise RuntimeError("启动失败：Redis 连接失败" + (": " + str(redis_status.get("error")) if redis_status.get("error") else ""))
print("Redis 连接成功")




MERAKI_API_KEY = os.getenv("MERAKI_API_KEY")
ORGANIZATION_ID = os.getenv("ORGANIZATION_ID")
MERAKI_API_BASE = os.getenv("MERAKI_API_BASE", "https://n3.dashboard.meraki.cn/api/v1")

if not MERAKI_API_KEY:
    raise RuntimeError("启动失败：未检测到 Meraki API Key，请在 .env 中设置 MERAKI_API_KEY")
else:
    print(MERAKI_API_KEY + 'cv')
response = []
MERAKI_DEFAULT_ORG_ID = None
try:
    dashboard = meraki.DashboardAPI(api_key=MERAKI_API_KEY, base_url=MERAKI_API_BASE, suppress_logging=True)
    response = dashboard.organizations.getOrganizations()
    if response:
        if len(response) > 1:
         #输出组织数量过多的警告日志
         warning = '查询到的组织id数量为: " ' + str(len(response)) + '"默认取第一个'
         RuntimeWarning(warning)
        first = response[0]
        if isinstance(first, dict):
            MERAKI_DEFAULT_ORG_ID = first.get("id")

            # 缓存进入redis
            # response_json =
            set(CacheKey.ORGANIZATIONS.value, json.dumps(first),ex=60*60*12)
except Exception as e:
    status = getattr(e, "status", None)
    if status == 401:
        raise RuntimeError("启动失败：MERAKI_API_KEY 无效或无权限访问 Meraki API")
    raise RuntimeError(f"启动失败：调用 Meraki API 失败：{e}")
if ORGANIZATION_ID:
    ids = {str(org.get("id")) for org in response if isinstance(org, dict) and "id" in org}
    if str(ORGANIZATION_ID) not in ids:
        raise RuntimeWarning("启动失败：.env 中的 ORGANIZATION_ID 与 MERAKI_API_KEY 可访问组织不一致")
else:
    ORGANIZATION_ID = MERAKI_DEFAULT_ORG_ID
    os.environ["ORGANIZATION_ID"] = str(MERAKI_DEFAULT_ORG_ID)
    RuntimeWarning("已将MERAKI_API_KEY 查询到的组织id赋值到env")

"""
    简便写法 
    orgs = dashboard.organizations.getOrganizations()
    print("所有组织信息: " + json.dumps(orgs, indent=2, ensure_ascii=False))

    return JsonResponse(orgs[0],safe=False, json_dumps_params={'indent': 2, 'ensure_ascii': False})
"""

print("项目启动 检测参数成功 ")
# === Banner 打印 ===
print(r"""
------------------------------------------------------------
   ____  _                          ____        _   
  |  _ \(_)_ __   __ _  ___  _ __  |  _ \  ___ | |_ 
  | | | | | '_ \ / _` |/ _ \| '_ \ | | | |/ _ \| __|
  | |_| | | | | | (_| | (_) | | | || |_| | (_) | |_ 
  |____/|_|_| |_|\__, |\___/|_| |_||____/ \___/ \__|
                 |___/                              
------------------------------------------------------------
Django 启动成功！配置加载完成。
Redis  链接成功 组织、网络信息 缓存成功
MERAKI_API_KEY: 已检测
------------------------------------------------------------
""")

#开启临时缓存 [一级]
# CACHES = {
#     'default': {
#         'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
#         'LOCATION': 'meraki-local-cache'
#     }
# }



# 开始缓存 networks
try:
    networks = dashboard.organizations.getOrganizationNetworks(
        ORGANIZATION_ID, total_pages='all'
    )
    print(len(networks))
    if networks:
       # 缓存进入redis
       res = json.dumps(networks)
       set(CacheKey.NETWORKS.value, res, ex=60*60*6)
except Exception as e:
    print(f"缓存 networks 失败: {e}")



# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-n=zdl)_2yc=f6zdx(!jry4%w1o&47dyj3qxz_6h_nl3#t9i4+1'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True
# 方式一：添加具体 IP（推荐生产环境）
#ALLOWED_HOSTS = ['127.0.0.1', 'localhost', '172.16.3.203']

# 方式二：允许所有主机（仅开发环境）
ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'meraki_Interface_forward.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'meraki_Interface_forward.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/

STATIC_URL = 'static/'

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


# Logging configuration
# 日志目录：meraki_Interface_forward 包目录下 logs，按天滚动，保留 7 天
# 当天日志：meraki.log，历史日志：meraki.YYYYMMDD.log
import logging.handlers
from datetime import datetime

# 日志目录：meraki_Interface_forward/logs
LOG_DIR = os.path.join(BASE_DIR, "meraki_Interface_forward", "logs")
os.makedirs(LOG_DIR, exist_ok=True)
LOG_FILE_PATH = os.path.join(LOG_DIR, "meraki.log")


class CustomTimedRotatingFileHandler(logging.handlers.TimedRotatingFileHandler):
    """
    自定义的按天滚动日志 handler，文件名格式：
    - 当天：meraki.log
    - 历史：meraki.YYYYMMDD.log
    """
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # 设置后缀格式为 .%Y%m%d，TimedRotatingFileHandler 会自动追加
        self.suffix = "%Y%m%d"

    def namer(self, name):
        """
        重写 namer 方法，将 meraki.log.YYYYMMDD 转换为 meraki.YYYYMMDD.log
        """
        # name 格式：/path/to/meraki.log.YYYYMMDD
        if name.endswith('.log'):
            # 当前文件，直接返回
            return name
        # 历史文件：meraki.log.YYYYMMDD -> meraki.YYYYMMDD.log
        base_dir = os.path.dirname(name)
        base_name = os.path.basename(name)
        # base_name 格式：meraki.log.YYYYMMDD
        if '.log.' in base_name:
            parts = base_name.split('.log.')
            if len(parts) == 2:
                # 提取日期部分
                date_str = parts[1]
                new_name = f"meraki.{date_str}.log"
                return os.path.join(base_dir, new_name)
        return name


LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        "verbose": {
            "format": "[{levelname}] {asctime} {name} {message}",
            "style": "{",
        },
        "simple": {
            "format": "[{levelname}] {name} {message}",
            "style": "{",
        },
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "verbose",
        },
        "file": {
            "()": CustomTimedRotatingFileHandler,
            "filename": LOG_FILE_PATH,
            "when": "midnight",
            "backupCount": 7,
            "encoding": "utf-8",
        },
    },
    "root": {
        "handlers": ["console", "file"],
        "level": "INFO",
    },
    "loggers": {
        # 项目内代码统一使用 meraki_Interface_forward.* 命名空间
        "meraki_Interface_forward": {
            "handlers": ["console", "file"],
            "level": "INFO",
            "propagate": False,
        },
    },
}
