import json
from django.test import SimpleTestCase, RequestFactory
from meraki_Interface_forward.redis_utils import CacheKey
import meraki_Interface_forward.views.device_views as views


class DiscoveryFilterNameFixTests(SimpleTestCase):
    def setUp(self):
        self.factory = RequestFactory()
        self._orig_get_json = views.get_json
        self._orig_get_org_devices = views.get_organization_devices

    def tearDown(self):
        views.get_json = self._orig_get_json
        views.get_organization_devices = self._orig_get_org_devices

    def _stub_get_json(self, key):
        if key == CacheKey.NETWORKS.value:
            return None
        if key == CacheKey.DEVICES.value:
            return [
                {"name": "", "serial": "Q3AL-2A5G-3AF5", "mac": "aa:bb:cc:dd:ee:ff", "networkId": "N1", "productType": "switch"},
                {"name": "AS01", "serial": "Q4AV-TBV5-C2XL", "mac": "14:9f:43:47:f2:38", "networkId": "N2", "productType": "switch"},
                {"name": "AS01", "serial": "Q5BX-XXXX-YYYY", "mac": "14:9f:43:47:f2:39", "networkId": "N3", "productType": "switch"},
            ]
        return None

    def test_empty_name_fixed_and_duplicates_deduped(self):
        views.get_json = self._stub_get_json
        views.get_organization_devices = lambda: []
        req = self.factory.post(
            "/discovery/host_prototype/filter",
            data=json.dumps({"filter_networks": []}),
            content_type="application/json",
        )
        res = views.discovery_host_prototype_filter(req)
        data = json.loads(res.content.decode("utf-8"))
        names = {d["serial"]: d.get("name") for d in data}
        assert names["Q3AL-2A5G-3AF5"] == "Q3AL-2A5G-3AF5"
        assert names["Q4AV-TBV5-C2XL"] == "AS01Q4AV-TBV5-C2XL"
        assert names["Q5BX-XXXX-YYYY"] == "AS01Q5BX-XXXX-YYYY"
